/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsLookAndFeel;
import com.pagosoft.plaf.PgsUtils;
import com.pagosoft.plaf.PlafOptions;
import com.pagosoft.swing.ColorUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.plaf.UIResource;

public class PgsIconFactory {
    private static Icon emptyIcon;
    private static Icon checkBoxIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonIcon;
    private static Icon radioMenuItemIcon;

    public static Icon getEmptyIcon() {
        if (emptyIcon == null) {
            emptyIcon = new EmptyIcon(PlafOptions.getDefaultMenuItemIconSize());
        }
        return emptyIcon;
    }

    protected static void drawCheck(Component component, Graphics graphics, int n2, int n3) {
        graphics.translate(n2, n3);
        graphics.drawLine(3, 5, 3, 5);
        graphics.fillRect(3, 6, 2, 2);
        graphics.drawLine(4, 8, 9, 3);
        graphics.drawLine(5, 8, 9, 4);
        graphics.drawLine(5, 9, 9, 5);
        graphics.translate(-n2, -n3);
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioMenuItemIcon == null) {
            radioMenuItemIcon = new RadioButtonIcon();
        }
        return radioMenuItemIcon;
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonIcon() {
        }

        protected int getControlSize() {
            return 13;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            int n4 = this.getControlSize();
            boolean bl = buttonModel.isSelected();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (buttonModel.isEnabled()) {
                graphics2D.setColor(PgsLookAndFeel.getControlHighlight());
                graphics2D.fillOval(n2, n3, n4, n4);
                if (buttonModel.isRollover()) {
                    graphics2D.setColor(PgsLookAndFeel.getGlow());
                    graphics2D.drawOval(n2 + 1, n3 + 1, n4 - 3, n4 - 3);
                }
                graphics2D.setColor(PgsLookAndFeel.getControlDarkShadow());
                graphics2D.drawOval(n2, n3, n4 - 1, n4 - 1);
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    graphics2D.setColor(PgsLookAndFeel.getControlShadow());
                    graphics2D.fillOval(n2 + 1, n3 + 1, n4 - 2, n4 - 2);
                }
                graphics2D.setColor(PgsLookAndFeel.getControlInfo());
            } else {
                graphics2D.setColor(PgsLookAndFeel.getControlShadow());
                graphics2D.drawOval(n2, n3, n4 - 1, n4 - 1);
            }
            if (bl) {
                if (buttonModel.isEnabled()) {
                    graphics2D.setColor(PgsLookAndFeel.getPrimaryControlDarkShadow());
                } else {
                    graphics2D.setColor(buttonModel.isEnabled() ? PgsLookAndFeel.getPrimaryControlDarkShadow() : PgsLookAndFeel.getControlShadow());
                }
                graphics2D.fillOval(n2 + 3, n3 + 3, n4 - 6, n4 - 6);
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }

        public int getIconWidth() {
            return this.getControlSize();
        }

        public int getIconHeight() {
            return this.getControlSize();
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxMenuItemIcon() {
        }

        protected int getControlSize() {
            return 13;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            int n4 = this.getControlSize();
            boolean bl = buttonModel.isSelected();
            if (buttonModel.isEnabled()) {
                graphics.setColor(PgsLookAndFeel.getControlHighlight());
                graphics.fillRect(n2, n3, n4, n4);
                if (buttonModel.isRollover()) {
                    graphics.setColor(PgsLookAndFeel.getPrimaryControl());
                    graphics.drawRect(n2 + 1, n3 + 1, n4 - 3, n4 - 3);
                }
                graphics.setColor(PgsLookAndFeel.getControlDarkShadow());
                graphics.drawRect(n2, n3, n4 - 1, n4 - 1);
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    graphics.setColor(PgsLookAndFeel.getControlShadow());
                    graphics.fillRect(n2 + 1, n3 + 1, n4 - 2, n4 - 2);
                }
                graphics.setColor(PgsLookAndFeel.getControlInfo());
            } else {
                graphics.setColor(PgsLookAndFeel.getControlShadow());
                graphics.drawRect(n2, n3, n4 - 1, n4 - 1);
            }
            if (bl) {
                graphics.setColor(buttonModel.isEnabled() ? PgsLookAndFeel.getPrimaryControlDarkShadow() : PgsLookAndFeel.getControlShadow());
                PgsIconFactory.drawCheck(component, graphics, n2, n3);
            }
        }

        public int getIconWidth() {
            return this.getControlSize();
        }

        public int getIconHeight() {
            return this.getControlSize();
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxIcon() {
        }

        protected int getControlSize() {
            return 13;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JCheckBox jCheckBox = (JCheckBox)component;
            ButtonModel buttonModel = jCheckBox.getModel();
            int n4 = this.getControlSize();
            boolean bl = buttonModel.isSelected();
            if (buttonModel.isEnabled()) {
                graphics.setColor(PgsLookAndFeel.getControlHighlight());
                graphics.fillRect(n2, n3, n4, n4);
                PgsUtils.drawGradient(graphics, n2, n3, n4, n4, ColorUtils.getTranslucentColor(PgsLookAndFeel.getControlShadow(), 0), ColorUtils.getTranslucentColor(PgsLookAndFeel.getControlShadow(), 50));
                if (buttonModel.isRollover()) {
                    graphics.setColor(PgsLookAndFeel.getGlow());
                    graphics.drawRect(n2 + 1, n3 + 1, n4 - 3, n4 - 3);
                }
                graphics.setColor(PgsLookAndFeel.getControlDarkShadow());
                graphics.drawRect(n2, n3, n4 - 1, n4 - 1);
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    graphics.setColor(PgsLookAndFeel.getControlShadow());
                    graphics.fillRect(n2 + 1, n3 + 1, n4 - 2, n4 - 2);
                }
                graphics.setColor(PgsLookAndFeel.getControlInfo());
            } else {
                graphics.setColor(PgsLookAndFeel.getControlShadow());
                graphics.drawRect(n2, n3, n4 - 1, n4 - 1);
            }
            if (bl) {
                graphics.setColor(buttonModel.isEnabled() ? PgsLookAndFeel.getPrimaryControlDarkShadow() : PgsLookAndFeel.getControlShadow());
                PgsIconFactory.drawCheck(component, graphics, n2, n3);
            }
        }

        public int getIconWidth() {
            return this.getControlSize();
        }

        public int getIconHeight() {
            return this.getControlSize();
        }
    }

    private static class EmptyIcon
    implements Icon,
    UIResource,
    Serializable {
        private Dimension size;

        public EmptyIcon(Dimension dimension) {
            this.size = dimension;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        }

        public int getIconWidth() {
            return this.size.width;
        }

        public int getIconHeight() {
            return this.size.height;
        }
    }
}

